classdef enum_load_source < Simulink.IntEnumType
    enumeration
        driver_acl_norm(0)
        engine_load_norm(1)
        driver_acl_pct(2)
        engine_load_pct(3)
		engine_load_Nm(4)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
